/*
* This code was generated by a Yellicode template.
* 
* Changes to this file may cause incorrect behavior and will be lost if the code is regenerated.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;

using Bookstore.Api.Data;
using Bookstore.Api.Resources;

namespace Bookstore.Api.Controllers
{
	[Route("api/author")]
	public partial class AuthorController : Controller
	{
		private readonly BookstoreContext _dbContext;
		private readonly ResourceMapper _resourceMapper;

		public AuthorController(BookstoreContext dbContext)
		{
			_dbContext = dbContext;
			_resourceMapper = new ResourceMapper(dbContext);
		}

		[HttpGet]
		public IEnumerable<AuthorResource> GetAll()
		{
			return _dbContext.AuthorSet
				.Select(_resourceMapper.ToAuthorResource)
				.ToList();
		}

		[HttpGet("options")]
		public IEnumerable<ResourceInfo> GetAllOptions()
		{
			return _dbContext.AuthorSet
				.Select(e => new ResourceInfo(e.Id, e.GetDisplayName()))
				.ToList();
		}

		[HttpGet("{id}", Name = "GetAuthor")]
		public IActionResult GetById(int id)
		{
			var entity = _dbContext.AuthorSet
				.FirstOrDefault(e => e.Id == id);

			if (entity == null) { return NotFound(); }
			return new ObjectResult(_resourceMapper.ToAuthorResource(entity));
		}

		[HttpPost]
		public IActionResult Create([FromBody] AuthorResource resource)
		{
			if (resource == null) { return BadRequest(); }
			var entity = _resourceMapper.ToAuthor(resource);
			_dbContext.AuthorSet.Add(entity);
			_dbContext.SaveChanges();
			return CreatedAtRoute("GetAuthor", new { id = entity.Id }, resource);
		}

		[HttpPut("{id}")]
		public IActionResult Update(int id, [FromBody] AuthorResource resource)
		{
			if (resource == null || resource.Id != id) { return BadRequest(); }
			var entity = _dbContext.AuthorSet
				.FirstOrDefault(e => e.Id == id);

			if (entity == null) { return NotFound(); }

			_resourceMapper.ToAuthor(entity, resource);

			_dbContext.AuthorSet.Update(entity);
			_dbContext.SaveChanges();
			return new NoContentResult();
		}

		[HttpDelete("{id}")]
		public IActionResult Delete(int id)
		{
			var entity = _dbContext.AuthorSet.FirstOrDefault(e => e.Id == id);
			if (entity == null) { return NotFound(); }

			_dbContext.AuthorSet.Remove(entity);
			_dbContext.SaveChanges();
			return new NoContentResult();
		}
	}
}
