/*
* This code was generated by a Yellicode template.
* 
* Changes to this file may cause incorrect behavior and will be lost if the code is regenerated.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;

using Bookstore.Api.Data;
using Bookstore.Api.Resources;

namespace Bookstore.Api.Controllers
{
	[Route("api/book")]
	public partial class BookController : Controller
	{
		private readonly BookstoreContext _dbContext;
		private readonly ResourceMapper _resourceMapper;

		public BookController(BookstoreContext dbContext)
		{
			_dbContext = dbContext;
			_resourceMapper = new ResourceMapper(dbContext);
		}

		[HttpGet]
		public IEnumerable<BookResource> GetAll()
		{
			return _dbContext.BookSet
				.Include(e => e.Authors).ThenInclude(j => j.Author)
				.Include(e => e.Category)
				.Include(e => e.Language)
				.Select(_resourceMapper.ToBookResource)
				.ToList();
		}

		[HttpGet("options")]
		public IEnumerable<ResourceInfo> GetAllOptions()
		{
			return _dbContext.BookSet
				.Select(e => new ResourceInfo(e.Id, e.GetDisplayName()))
				.ToList();
		}

		[HttpGet("{id}", Name = "GetBook")]
		public IActionResult GetById(int id)
		{
			var entity = _dbContext.BookSet
				.Include(e => e.Authors).ThenInclude(j => j.Author)
				.Include(e => e.Category)
				.Include(e => e.Language)
				.FirstOrDefault(e => e.Id == id);

			if (entity == null) { return NotFound(); }
			return new ObjectResult(_resourceMapper.ToBookResource(entity));
		}

		[HttpPost]
		public IActionResult Create([FromBody] BookResource resource)
		{
			if (resource == null) { return BadRequest(); }
			var entity = _resourceMapper.ToBook(resource);
			_dbContext.BookSet.Add(entity);
			_dbContext.SaveChanges();
			return CreatedAtRoute("GetBook", new { id = entity.Id }, resource);
		}

		[HttpPut("{id}")]
		public IActionResult Update(int id, [FromBody] BookResource resource)
		{
			if (resource == null || resource.Id != id) { return BadRequest(); }
			var entity = _dbContext.BookSet
				.Include(e => e.Authors).ThenInclude(j => j.Author)
				.Include(e => e.Category)
				.Include(e => e.Language)
				.FirstOrDefault(e => e.Id == id);

			if (entity == null) { return NotFound(); }

			_resourceMapper.ToBook(entity, resource);

			_dbContext.BookSet.Update(entity);
			_dbContext.SaveChanges();
			return new NoContentResult();
		}

		[HttpDelete("{id}")]
		public IActionResult Delete(int id)
		{
			var entity = _dbContext.BookSet.FirstOrDefault(e => e.Id == id);
			if (entity == null) { return NotFound(); }

			_dbContext.BookSet.Remove(entity);
			_dbContext.SaveChanges();
			return new NoContentResult();
		}
	}
}
