/*
* This code was generated by a Yellicode template.
* 
* Changes to this file may cause incorrect behavior and will be lost if the code is regenerated.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;

using Bookstore.Api.Data;
using Bookstore.Api.Resources;

namespace Bookstore.Api.Controllers
{
	[Route("api/language")]
	public partial class LanguageController : Controller
	{
		private readonly BookstoreContext _dbContext;
		private readonly ResourceMapper _resourceMapper;

		public LanguageController(BookstoreContext dbContext)
		{
			_dbContext = dbContext;
			_resourceMapper = new ResourceMapper(dbContext);
		}

		[HttpGet]
		public IEnumerable<LanguageResource> GetAll()
		{
			return _dbContext.LanguageSet
				.Select(_resourceMapper.ToLanguageResource)
				.ToList();
		}

		[HttpGet("options")]
		public IEnumerable<ResourceInfo> GetAllOptions()
		{
			return _dbContext.LanguageSet
				.Select(e => new ResourceInfo(e.Id, e.GetDisplayName()))
				.ToList();
		}

		[HttpGet("{id}", Name = "GetLanguage")]
		public IActionResult GetById(int id)
		{
			var entity = _dbContext.LanguageSet
				.FirstOrDefault(e => e.Id == id);

			if (entity == null) { return NotFound(); }
			return new ObjectResult(_resourceMapper.ToLanguageResource(entity));
		}

		[HttpPost]
		public IActionResult Create([FromBody] LanguageResource resource)
		{
			if (resource == null) { return BadRequest(); }
			var entity = _resourceMapper.ToLanguage(resource);
			_dbContext.LanguageSet.Add(entity);
			_dbContext.SaveChanges();
			return CreatedAtRoute("GetLanguage", new { id = entity.Id }, resource);
		}

		[HttpPut("{id}")]
		public IActionResult Update(int id, [FromBody] LanguageResource resource)
		{
			if (resource == null || resource.Id != id) { return BadRequest(); }
			var entity = _dbContext.LanguageSet
				.FirstOrDefault(e => e.Id == id);

			if (entity == null) { return NotFound(); }

			_resourceMapper.ToLanguage(entity, resource);

			_dbContext.LanguageSet.Update(entity);
			_dbContext.SaveChanges();
			return new NoContentResult();
		}

		[HttpDelete("{id}")]
		public IActionResult Delete(int id)
		{
			var entity = _dbContext.LanguageSet.FirstOrDefault(e => e.Id == id);
			if (entity == null) { return NotFound(); }

			_dbContext.LanguageSet.Remove(entity);
			_dbContext.SaveChanges();
			return new NoContentResult();
		}
	}
}
