/*
* This code was generated by a Yellicode template.
* 
* Changes to this file may cause incorrect behavior and will be lost if the code is regenerated.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using Bookstore.Api.Data;

namespace Bookstore.Api.Resources
{
	/// <summary>
	/// A mapper class for conversion between REST resources and Entity Framework entities.
	/// </summary>
	public partial class ResourceMapper
	{
		private readonly BookstoreContext _dbContext;

		public ResourceMapper(BookstoreContext dbContext)
		{
			_dbContext = dbContext;
		}

		/// <summary>
		/// Creates a new AuthorResource from a Author entity.
		/// </summary>
		public AuthorResource ToAuthorResource(Author entity)
		{
			var resource = new AuthorResource();
			resource.DisplayName = entity.GetDisplayName();
			resource.Id = entity.Id;
			resource.FirstName = entity.FirstName;
			resource.LastName = entity.LastName;
			resource.About = entity.About;
			return resource;
		}

		/// <summary>
		/// Fills an Author instance from a AuthorResource entity.
		/// </summary>
		public void ToAuthor(Author entity, AuthorResource resource)
		{
			entity.Id = resource.Id;
			entity.Id = resource.Id;
			entity.FirstName = resource.FirstName;
			entity.LastName = resource.LastName;
			entity.About = resource.About;
		}

		/// <summary>
		/// Creates a new Author from a AuthorResource instance.
		/// </summary>
		public Author ToAuthor(AuthorResource resource)
		{
			var entity = new Author();
			this.ToAuthor(entity, resource);
			return entity;
		}

		/// <summary>
		/// Creates a new BookResource from a Book entity.
		/// </summary>
		public BookResource ToBookResource(Book entity)
		{
			var resource = new BookResource();
			resource.DisplayName = entity.GetDisplayName();
			resource.Id = entity.Id;
			resource.Title = entity.Title;
			resource.Authors = entity.Authors?.Select(e => new ResourceInfo(e.Author.Id, e.Author.GetDisplayName())).ToList();
			resource.Category = entity.Category != null ? new ResourceInfo(entity.Category.Id, entity.Category.GetDisplayName()) : null;
			resource.Language = entity.Language != null ? new ResourceInfo(entity.Language.Id, entity.Language.GetDisplayName()) : null;
			resource.ISBN = entity.ISBN;
			return resource;
		}

		/// <summary>
		/// Fills an Book instance from a BookResource entity.
		/// </summary>
		public void ToBook(Book entity, BookResource resource)
		{
			entity.Id = resource.Id;
			entity.Id = resource.Id;
			entity.Title = resource.Title;
			entity.Authors = resource.Authors?.Select(r => new BookAuthor(){ AuthorId = r.Id }).ToList();
			entity.CategoryId = resource.Category?.Id ?? 0;
			entity.LanguageId = resource.Language?.Id ?? 0;
			entity.ISBN = resource.ISBN;
		}

		/// <summary>
		/// Creates a new Book from a BookResource instance.
		/// </summary>
		public Book ToBook(BookResource resource)
		{
			var entity = new Book();
			this.ToBook(entity, resource);
			return entity;
		}

		/// <summary>
		/// Creates a new CategoryResource from a Category entity.
		/// </summary>
		public CategoryResource ToCategoryResource(Category entity)
		{
			var resource = new CategoryResource();
			resource.DisplayName = entity.GetDisplayName();
			resource.Id = entity.Id;
			resource.Name = entity.Name;
			resource.Description = entity.Description;
			return resource;
		}

		/// <summary>
		/// Fills an Category instance from a CategoryResource entity.
		/// </summary>
		public void ToCategory(Category entity, CategoryResource resource)
		{
			entity.Id = resource.Id;
			entity.Id = resource.Id;
			entity.Name = resource.Name;
			entity.Description = resource.Description;
		}

		/// <summary>
		/// Creates a new Category from a CategoryResource instance.
		/// </summary>
		public Category ToCategory(CategoryResource resource)
		{
			var entity = new Category();
			this.ToCategory(entity, resource);
			return entity;
		}

		/// <summary>
		/// Creates a new LanguageResource from a Language entity.
		/// </summary>
		public LanguageResource ToLanguageResource(Language entity)
		{
			var resource = new LanguageResource();
			resource.DisplayName = entity.GetDisplayName();
			resource.Id = entity.Id;
			resource.IsoCode = entity.IsoCode;
			resource.IsoName = entity.IsoName;
			return resource;
		}

		/// <summary>
		/// Fills an Language instance from a LanguageResource entity.
		/// </summary>
		public void ToLanguage(Language entity, LanguageResource resource)
		{
			entity.Id = resource.Id;
			entity.Id = resource.Id;
			entity.IsoCode = resource.IsoCode;
			entity.IsoName = resource.IsoName;
		}

		/// <summary>
		/// Creates a new Language from a LanguageResource instance.
		/// </summary>
		public Language ToLanguage(LanguageResource resource)
		{
			var entity = new Language();
			this.ToLanguage(entity, resource);
			return entity;
		}
	}
}
